package devices;

import javax.swing.JFrame;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

import centralSystem.IVisualizer;

public class Visualizer extends JFrame implements IVisualizer {

	private static final String[] SERVICES = {"SERVIZI POSTALI", "SERVIZI FINANZIARI", "ALTRI SERVIZI"};
	private JTextArea area = new JTextArea();

	public Visualizer() {
		super("Poste Italiane - Storico Turni");
		area.setEditable(false);
		JScrollPane areaPanel = new JScrollPane(area);
		super.getContentPane().add(areaPanel);
		super.setSize(300, 300);
		super.setResizable(false);
		super.setVisible(true);
		super.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}
	
	@Override
	public void insert(int counter, int serviceType, int client) {
		area.insert("Cassa: "+(counter=counter+1)+": "+client+" di "+SERVICES[serviceType], area.getCaretPosition());
		area.insert("\n", area.getCaretPosition());
	}

}
